/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.moduleviews;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.buildings.IBuildingWorkerView;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.modules.FarmerFieldsModuleWindow;
import com.minecolonies.coremod.network.messages.server.colony.building.farmer.AssignFieldMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.farmer.AssignmentModeMessage;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class FarmerFieldModuleView
extends AbstractBuildingModuleView {
    private boolean shouldAssignFieldManually;
    @NotNull
    private List<BlockPos> fields = new ArrayList<BlockPos>();
    private int amountOfFields;

    @Override
    public String getDesc() {
        return "com.minecolonies.coremod.gui.workerhuts.farmerhut.fields";
    }

    @Override
    public void deserialize(@NotNull PacketBuffer buf) {
        this.fields = new ArrayList<BlockPos>();
        this.shouldAssignFieldManually = buf.readBoolean();
        int size = buf.readInt();
        for (int i = 1; i <= size; ++i) {
            BlockPos pos = buf.func_179259_c();
            this.fields.add(pos);
        }
        this.amountOfFields = buf.readInt();
    }

    public boolean assignFieldManually() {
        return this.shouldAssignFieldManually;
    }

    @NotNull
    public List<BlockPos> getFields() {
        return this.fields;
    }

    public int getAmountOfFields() {
        return this.amountOfFields;
    }

    public void setAssignFieldManually(boolean assignFieldManually) {
        Network.getNetwork().sendToServer(new AssignmentModeMessage(this.buildingView, assignFieldManually));
        this.shouldAssignFieldManually = assignFieldManually;
    }

    public void changeFields(BlockPos id, boolean addNewField, ScarecrowTileEntity scarecrowTileEntity) {
        Network.getNetwork().sendToServer(new AssignFieldMessage(this.buildingView, addNewField, id));
        scarecrowTileEntity.setTaken(addNewField);
        if (this.buildingView instanceof IBuildingWorkerView) {
            if (addNewField && !((IBuildingWorkerView)this.buildingView).getWorkerId().isEmpty()) {
                scarecrowTileEntity.setOwner(((IBuildingWorkerView)this.buildingView).getWorkerId().get(0), this.getColony());
                ++this.amountOfFields;
            } else {
                scarecrowTileEntity.setOwner(0, this.getColony());
                --this.amountOfFields;
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Window getWindow() {
        return new FarmerFieldsModuleWindow(this.buildingView, this);
    }

    @Override
    public String getIcon() {
        return "field";
    }
}

